/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.co.demon.obelisk.xobj.BinaryExpr;
import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Extern;
import uk.co.demon.obelisk.xobj.Library;
import uk.co.demon.obelisk.xobj.Module;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.UnaryExpr;
import uk.co.demon.obelisk.xobj.Value;

public final class Parser {
    private static SAXParserFactory factory = null;
    private static SAXParser parser = null;
    private static Handler handler = new Handler();
    private static Stack<Object> stack = new Stack();

    public static Object parse(String fileName) {
        try {
            stack.clear();
            Parser.getParser().parse((InputStream)new FileInputStream(fileName), (DefaultHandler)handler);
        }
        catch (FileNotFoundException error) {
            return null;
        }
        catch (Exception error) {
            error.printStackTrace(System.err);
            return null;
        }
        return stack.pop();
    }

    private static SAXParser getParser() {
        if (parser == null) {
            try {
                if (factory == null) {
                    factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(false);
                    factory.setValidating(false);
                }
                parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException error) {
                System.err.println("Error: No SAX Parser installed in the JAVA runtime");
                System.exit(1);
            }
            catch (SAXException error) {
                System.err.println("Error: Failed to create a SAX parser");
                System.exit(1);
            }
        }
        return parser;
    }

    private static class Handler
    extends DefaultHandler {
        private Stack<String> tags = new Stack();
        private Module module;
        private Section section;
        private String sect;
        private String chars;

        private Handler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            int span = this.module.getByteSize() / 4;
            this.chars = new String(ch, start, length);
            if (this.tags.peek().equals("section")) {
                int index = 0;
                while (index < length) {
                    this.section.addByte(Long.parseLong(this.chars.substring(index, index + span), 16));
                    index += span;
                }
            } else if (this.tags.peek().equals("gbl")) {
                stack.push(this.chars);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            localName = qName;
            this.tags.push(localName);
            switch (localName.charAt(0)) {
                case 'l': {
                    if (!localName.equals("library")) break;
                    stack.push(new Library());
                    break;
                }
                case 'm': {
                    if (!localName.equals("module")) break;
                    this.module = new Module(attrs.getValue("target"), !attrs.getValue("endian").equals("little"), Integer.parseInt(attrs.getValue("byteSize")));
                    if (attrs.getIndex("name") != -1) {
                        this.module.setName(attrs.getValue("name"));
                    }
                    stack.push(this.module);
                    break;
                }
                case 's': {
                    if (!localName.equals("section")) break;
                    if (attrs.getIndex("addr") != -1) {
                        long start = Long.parseLong(attrs.getValue("addr"), 16);
                        this.section = this.module.findSection(attrs.getValue("name"), start);
                        break;
                    }
                    this.section = this.module.findSection(attrs.getValue("name"));
                    break;
                }
                case 'v': {
                    if (!localName.equals("val")) break;
                    this.sect = attrs.getValue("sect");
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            localName = qName;
            this.tags.pop();
            switch (localName.charAt(0)) {
                case 'a': {
                    if (localName.equals("add")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Add(lhs, rhs));
                        return;
                    }
                    if (!localName.equals("and")) break;
                    Expr rhs = (Expr)stack.pop();
                    Expr lhs = (Expr)stack.pop();
                    stack.push(new BinaryExpr.Add(lhs, rhs));
                    return;
                }
                case 'b': {
                    if (!localName.equals("byte")) break;
                    Expr exp = (Expr)stack.pop();
                    this.section.addByte(exp);
                    return;
                }
                case 'c': {
                    if (!localName.equals("cpl")) break;
                    Expr exp = (Expr)stack.pop();
                    stack.push(new UnaryExpr.Cpl(exp));
                    return;
                }
                case 'd': {
                    if (!localName.equals("div")) break;
                    Expr rhs = (Expr)stack.pop();
                    Expr lhs = (Expr)stack.pop();
                    stack.push(new BinaryExpr.Div(lhs, rhs));
                    return;
                }
                case 'e': {
                    if (localName.equals("eq")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Eq(lhs, rhs));
                        return;
                    }
                    if (!localName.equals("ext")) break;
                    stack.push(new Extern(this.chars));
                    break;
                }
                case 'g': {
                    if (localName.equals("ge")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Ge(lhs, rhs));
                        return;
                    }
                    if (localName.equals("gt")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Gt(lhs, rhs));
                        return;
                    }
                    if (!localName.equals("gbl")) break;
                    Expr exp = (Expr)stack.pop();
                    String sym = (String)stack.pop();
                    this.module.addGlobal(sym, exp);
                    break;
                }
                case 'l': {
                    if (localName.equals("le")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Le(lhs, rhs));
                        return;
                    }
                    if (localName.equals("lt")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Lt(lhs, rhs));
                        return;
                    }
                    if (localName.equals("land")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.LAnd(lhs, rhs));
                        return;
                    }
                    if (localName.equals("lor")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.LOr(lhs, rhs));
                        return;
                    }
                    if (localName.equals("long")) {
                        Expr exp = (Expr)stack.pop();
                        this.section.addLong(exp);
                        return;
                    }
                    if (!localName.equals("library")) break;
                    Stack<Module> modules = new Stack<Module>();
                    while (stack.peek() instanceof Module) {
                        modules.push((Module)stack.pop());
                    }
                    Library library = (Library)stack.peek();
                    while (!modules.empty()) {
                        library.addModule((Module)modules.pop());
                    }
                    break;
                }
                case 'm': {
                    if (!localName.equals("mod")) break;
                    Expr rhs = (Expr)stack.pop();
                    Expr lhs = (Expr)stack.pop();
                    stack.push(new BinaryExpr.Mod(lhs, rhs));
                    return;
                }
                case 'n': {
                    if (localName.equals("ne")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Ne(lhs, rhs));
                        return;
                    }
                    if (localName.equals("neg")) {
                        Expr exp = (Expr)stack.pop();
                        stack.push(new UnaryExpr.Neg(exp));
                        return;
                    }
                    if (!localName.equals("not")) break;
                    Expr exp = (Expr)stack.pop();
                    stack.push(new UnaryExpr.Not(exp));
                    return;
                }
                case 'o': {
                    if (!localName.equals("or")) break;
                    Expr rhs = (Expr)stack.pop();
                    Expr lhs = (Expr)stack.pop();
                    stack.push(new BinaryExpr.Or(lhs, rhs));
                    return;
                }
                case 's': {
                    if (localName.equals("sub")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Sub(lhs, rhs));
                        return;
                    }
                    if (localName.equals("shl")) {
                        Expr rhs = (Expr)stack.pop();
                        Expr lhs = (Expr)stack.pop();
                        stack.push(new BinaryExpr.Shl(lhs, rhs));
                        return;
                    }
                    if (!localName.equals("shr")) break;
                    Expr rhs = (Expr)stack.pop();
                    Expr lhs = (Expr)stack.pop();
                    stack.push(new BinaryExpr.Shr(lhs, rhs));
                    return;
                }
                case 'v': {
                    if (!localName.equals("val")) break;
                    int value = Integer.parseInt(this.chars);
                    if (this.sect != null) {
                        stack.push(new Value(this.module.findSection(this.sect), value));
                    } else {
                        stack.push(new Value(null, value));
                    }
                    return;
                }
                case 'w': {
                    if (!localName.equals("word")) break;
                    Expr exp = (Expr)stack.pop();
                    this.section.addWord(exp);
                    return;
                }
                case 'x': {
                    if (!localName.equals("xor")) break;
                    Expr rhs = (Expr)stack.pop();
                    Expr lhs = (Expr)stack.pop();
                    stack.push(new BinaryExpr.Xor(lhs, rhs));
                    return;
                }
            }
        }
    }
}

